# Audio1.TV Roku Channel

Premium music video streaming channel for Roku devices.

## Version 2.0

### Features
- **Premium UI**: Gold accent branding, hero banner with focused content
- **HLS Streaming**: Adaptive quality via Audio1 CDN
- **Poster Navigation**: Horizontal scrolling rows with focus animations
- **Video Playback**: Full-screen player with progress bar

### Components

| Component | Description |
|-----------|-------------|
| `Audio1Scene.xml` | Main scene with hero banner and content rows |
| `Audio1Card.xml` | Poster art card with focus animation |
| `Audio1CDN.brs` | CDN client for HLS streaming |
| `ContentReader.xml` | Task node for API content loading |

### Content Structure

The channel loads content from the Audio1.TV API:
```
https://audio1.tv/api/feed
```

Falls back to local content if API is unavailable.

### Row Layout
- **Featured**: Daily Mix, Top 50, New Releases, Throwbacks
- **Live & Events**: Live Now, Upcoming, Replays
- **Genres**: Hip Hop, R&B, Pop, Rock, Electronic
- **Shoppertainment**: Shop the Look, Merch Drops

### Development

1. Install Roku developer tools
2. Enable developer mode on your Roku device
3. Package and deploy:
   ```bash
   # Use Roku's packaging tools or VS Code extension
   ```

### API Integration

Videos are streamed via the Audio1 CDN:
```brightscript
m.cdn = Audio1CDN("https://agentcache.ai")
streamUrl = m.cdn.getMasterPlaylistUrl(videoId)
```

### Assets

All channel artwork is in `images/` directory:
- `*_poster_hd.jpg` - Poster thumbnails (260x390)
- `*_hero_hd.jpg` - Hero backgrounds (1920x540)
- `*_tile_hd.jpg` - Grid tiles

### Colors
- Gold accent: `0xFFD700FF`
- Background: `0x0A0A0AFF`
- Text: `0xFFFFFFFF`
- Muted text: `0xCCCCCCFF`
