sub init()
  m.logOutput = m.top.findNode("logOutput")
  m.history = []
end sub

sub log(params as object)
  msg = params.message
  addMessage("[INFO] " + msg)
end sub

sub error(params as object)
  msg = params.message
  addMessage("[ERROR] " + msg)
end sub

sub addMessage(msg as string)
  timestamp = CreateObject("roDateTime")
  timeStr = timestamp.asSeconds().toStr()
  
  ' Add to history
  m.history.Push(timeStr + ": " + msg)
  
  ' Keep only last 8 lines
  while m.history.Count() > 8
    m.history.Shift()
  end while
  
  ' Render
  fullText = ""
  for each line in m.history
    fullText = fullText + line + chr(10)
  end for
  
  m.logOutput.text = fullText
end sub