sub init()
    m.poster = m.top.findNode("poster")
    m.title = m.top.findNode("title")
    m.metadata = m.top.findNode("metadata")
    m.description = m.top.findNode("description")
    m.playButton = m.top.findNode("playButton")

    m.playButton.observeField("buttonSelected", "onPlayPressed")
    
    ' Initialize Audio1 CDN client
    m.cdn = Audio1CDN("https://agentcache.ai")
end sub

sub onContentChanged()
    m.content = m.top.content
    if m.content <> invalid
        print "--- Details Screen: Content Set ---"
        print "Title: " + m.content.Title
        
        ' Update UI elements
        if m.poster <> invalid and m.content.hdPosterUrl <> invalid
            m.poster.uri = m.content.hdPosterUrl
        end if
        
        if m.title <> invalid
            m.title.text = m.content.title
        end if
        
        if m.description <> invalid and m.content.description <> invalid
            m.description.text = m.content.description
        end if
    end if
end sub

sub onPlayPressed()
    print "PLAY PRESSED: "; m.top.content.title
    playContent(m.top.content)
end sub

sub playContent(contentItem as Object)
    print "--- Playing Content ---"
    
    video = CreateObject("roSGNode", "Video")
    content = CreateObject("roSGNode", "ContentNode")
    content.title = contentItem.title
    
    ' Determine the stream URL using CDN client
    streamUrl = ""
    streamFormat = "hls"
    
    ' Priority 1: Check for videoId (use CDN for HLS)
    if contentItem.videoId <> invalid and contentItem.videoId <> ""
        print "Using CDN for videoId: " + contentItem.videoId
        quality = detectOptimalQuality()
        streamUrl = m.cdn.getMasterPlaylistUrl(contentItem.videoId)
        streamFormat = "hls"
        print "CDN URL: " + streamUrl + " (quality: " + quality + ")"
    
    ' Priority 2: Check for direct streamUrl
    else if contentItem.streamUrl <> invalid and contentItem.streamUrl <> ""
        print "Using direct streamUrl"
        streamUrl = contentItem.streamUrl
        
        ' Detect format from URL
        if streamUrl.instr(".m3u8") > 0
            streamFormat = "hls"
        else if streamUrl.instr(".mp4") > 0
            streamFormat = "mp4"
        else if streamUrl.instr(".mpd") > 0
            streamFormat = "dash"
        end if
    
    ' Priority 3: Check for legacy url field
    else if contentItem.url <> invalid and contentItem.url <> ""
        print "Using legacy url field"
        streamUrl = contentItem.url
        streamFormat = "mp4"
    
    ' Fallback: Demo video
    else
        print "No stream URL found, using demo video"
        streamUrl = "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
        streamFormat = "mp4"
    end if
    
    print "Final Stream URL: " + streamUrl
    print "Stream Format: " + streamFormat
    
    content.url = streamUrl
    content.streamFormat = streamFormat
    
    ' Set content and start playback
    video.content = content
    m.top.getScene().appendChild(video)
    video.control = "play"
    video.setFocus(true)
    
    ' Store reference for cleanup
    m.activeVideo = video
    
    ' Observe video state for error handling
    video.observeField("state", "onVideoStateChange")
end sub

sub onVideoStateChange()
    if m.activeVideo <> invalid
        state = m.activeVideo.state
        print "Video state: " + state
        
        if state = "error"
            errorInfo = m.activeVideo.errorInfo
            if errorInfo <> invalid
                print "Video Error: " + errorInfo.message
            end if
        else if state = "finished"
            print "Video playback finished"
        end if
    end if
end sub

function onKeyEvent(key as String, press as Boolean) as Boolean
    if press and key = "back"
        ' Stop video if playing
        if m.activeVideo <> invalid
            m.activeVideo.control = "stop"
            m.top.getScene().removeChild(m.activeVideo)
            m.activeVideo = invalid
        end if
        
        m.top.parent.removeChild(m.top)
        return true
    end if
    return false
end function
