sub init()
    m.top.backgroundColor = "#000000"
    
    m.rowList = m.top.findNode("mainRowList")
    m.heroPoster = m.top.findNode("heroPoster")
    m.heroTitle = m.top.findNode("heroTitle")
    m.heroDescription = m.top.findNode("heroDescription")
    
    m.rowList.observeField("rowItemFocused", "onItemFocused")
    m.rowList.observeField("rowItemSelected", "onItemSelected")

    ' Create Content
    createContent()
    
    m.rowList.setFocus(true)
end sub

sub createContent()
    content = createObject("roSGNode", "ContentNode")

    ' Define our rows using real assets
    rows = [
        { title: "Featured Channels", items: getHipChannels() },
        { title: "Audio1 Originals",  items: getHipOriginals() },
        { title: "More from Audio1",  items: getHipExtras() },
        { title: "Audio1 Labs 🧪",      items: getHipLabs() } ' Added Audio1 Labs row
    ]

    for each row in rows
        rowNode = content.createChild("ContentNode")
        rowNode.title = row.title
        for each item in row.items
            rowNode.appendChild(item)
        end for
    end for

    m.rowList.content = content
end sub

function getHipChannels() as Object
    items = []
    
    items.push(createItem("Audio1 Main", "pkg:/images/hip_networks_poster_hd.jpg", "pkg:/images/hip_networks_hero_hd.jpg", "Streaming at its Peak. The best of Audio1 all in one place."))
    items.push(createItem("Audio1 Edge", "pkg:/images/vint_edge_poster_hd.jpg", "pkg:/images/vint_edge_hero_hd.jpg", "Vintage Edge. Classic content remastered for the modern era."))
    items.push(createItem("Audio1 Horror", "pkg:/images/hip_horror_poster_hd.jpg", "pkg:/images/hip_horror_hero_hd.jpg", "Scary good content. Watch if you dare."))
    items.push(createItem("Audio1 Music", "pkg:/images/hip_music_poster_hd.jpg", "pkg:/images/hip_music_hero_hd.jpg", "Feel the beat. Music videos, concerts, and more."))
    items.push(createItem("Audio1 Movies", "pkg:/images/hip_movies_poster_hd.jpg", "pkg:/images/hip_movies_hero_hd.jpg", "Blockbuster hits and indie gems."))
    
    return items
end function

function getHipOriginals() as Object
    items = []
    
    items.push(createItem("HIP Live", "pkg:/images/hip_live_poster_hd.jpg", "pkg:/images/hip_live_hero_hd.jpg", "Live events as they happen."))
    items.push(createItem("HIP Scripted", "pkg:/images/hip_scripted_poster_hd.jpg", "pkg:/images/hip_scripted_hero_hd.jpg", "Original scripted series and dramas."))
    items.push(createItem("HIP Unscripted", "pkg:/images/hip_unscripted_poster_hd.jpg", "pkg:/images/hip_unscripted_hero_hd.jpg", "Reality TV and unscripted entertainment."))
    items.push(createItem("HIP Pods", "pkg:/images/hip_pods_poster_hd.jpg", "pkg:/images/hip_pods_hero_hd.jpg", "Listen and watch your favorite podcasts."))
    items.push(createItem("HIP Smashcuts", "pkg:/images/hip_smashcuts_poster_hd.jpg", "pkg:/images/hip_smashcuts_hero_hd.jpg", "Fast-paced, short-form content."))
    
    return items
end function

function getHipExtras() as Object
    items = []
    
    items.push(createItem("HIP Originals", "pkg:/images/hip_originals_poster_hd.jpg", "pkg:/images/hip_originals_hero_hd.jpg", "Exclusive content you won't find anywhere else."))
    items.push(createItem("HIP Shop", "pkg:/images/hip_shop_poster_hd.jpg", "pkg:/images/hip_shop_hero_hd.jpg", "Shop the look. Merchandise and more."))
    items.push(createItem("HIP Randos", "pkg:/images/hip_randos_poster_hd.jpg", "pkg:/images/hip_randos_hero_hd.jpg", "Random fun stuff."))
    items.push(createItem("HIP After Dark", "pkg:/images/hip_afterdark_poster_hd.jpg", "pkg:/images/hip_afterdark_hero_hd.jpg", "Late night entertainment."))
    items.push(createItem("HIP Funny", "pkg:/images/hip_funny_poster_hd.jpg", "pkg:/images/hip_funny_hero_hd.jpg", "Laugh out loud comedy."))
    
    return items
    return items
end function

function getHipLabs() as Object
    items = []
    
    item = createItem("HIP Labs 🧪", "pkg:/images/hip_labs_poster_hd.jpg", "pkg:/images/hip_labs_hero_hd.jpg", "Experimental features and interactive tests.")
    item.id = "lab_entry"
    items.push(item)
    
    return items
end function

function createItem(title as String, poster as String, hero as String, description as String) as Object
    item = createObject("roSGNode", "ContentNode")
    item.title = title
    item.hdPosterUrl = poster
    item.sdPosterUrl = poster
    item.hdBackgroundImageUrl = hero
    item.description = description
    return item
end function

sub onItemFocused()
    row = m.rowList.rowItemFocused[0]
    col = m.rowList.rowItemFocused[1]
    
    if m.rowList.content <> invalid
        rowNode = m.rowList.content.getChild(row)
        if rowNode <> invalid
            item = rowNode.getChild(col)
            if item <> invalid
                m.heroTitle.text = item.title
                m.heroDescription.text = item.description
                m.heroPoster.uri = item.hdBackgroundImageUrl
            end if
        end if
    end if
end sub

sub onItemSelected()
    selected = m.rowList.rowItemSelected
    row = m.rowList.content.getChild(selected[0])
    item = row.getChild(selected[1])

    ' Show Details Screen
    itemContent = item ' Use the already determined 'item' as itemContent
    
    if itemContent.id = "lab_entry"
        print "Entering Lab Mode..."
        showLabScene()
    else
        ' If m.detailsScreen is not already created, create it.
        if m.detailsScreen = invalid
            m.detailsScreen = createObject("roSGNode", "DetailsScreen")
            m.top.appendChild(m.detailsScreen)
        end if
        m.detailsScreen.content = itemContent
        m.detailsScreen.visible = true
        m.detailsScreen.setFocus(true)
    end if
end sub

sub showLabScene()
    print "*** Entering HIP Labs Mode ***"
    
    ' Hide the main scene UI
    m.rowList.visible = false
    m.heroPoster.visible = false
    m.heroTitle.visible = false
    m.heroDescription.visible = false
    
    ' Create and add LabScene
    if m.labScene = invalid
        m.labScene = createObject("roSGNode", "LabScene")
        m.top.appendChild(m.labScene)
    end if
    
    m.labScene.visible = true
    m.labScene.setFocus(true)
    
    print "*** Lab Scene created and focused ***"
end sub
